import { world, system, GameMode } from "@minecraft/server";
const overworld = world.getDimension("overworld");
const spawnEggs = [
    "sf_nba:beetle_spawn_egg", "sf_nba:butterfly_spawn_egg", "sf_nba:coyote_spawn_egg", "sf_nba:dragonfly_spawn_egg",
    "sf_nba:duck_spawn_egg", "sf_nba:fennec_fox_spawn_egg", "sf_nba:giant_salamander_spawn_egg", "sf_nba:goose_spawn_egg",
    "sf_nba:hamster_spawn_egg", "sf_nba:iguana_spawn_egg", "sf_nba:jellyfish_spawn_egg", "sf_nba:lizard_spawn_egg",
    "sf_nba:monkey_spawn_egg", "sf_nba:octopus_spawn_egg", "sf_nba:owl_spawn_egg", "sf_nba:platypus_spawn_egg",
    "sf_nba:rat_spawn_egg", "sf_nba:tree_frog_spawn_egg", "sf_nba:ray_spawn_egg", "sf_nba:seal_spawn_egg",
    "sf_nba:snail_spawn_egg", "sf_nba:tiger_spawn_egg", "sf_nba:tortoise_spawn_egg", "sf_nba:toucan_spawn_egg",
];
world.beforeEvents.itemUseOn.subscribe(e => {
    const spawnEgg = e.itemStack.typeId;
    const block = e.block
    const playerGamemode = e.source?.getGameMode();
    const blockLocation = block.location;
    const blockFace = e.blockFace;
    if (block.permutation.matches('minecraft:frame') || block.permutation.matches('minecraft:glow_frame')) return;
    const spawnLocation = { x: blockLocation.x + 0.5, y: blockLocation.y + 0.5, z: blockLocation.z + 0.5 };
    switch (blockFace) {
        case 'Up':
            spawnLocation.y += 0.5;
            break;
        case 'Down':
            spawnLocation.y -= 0.5;
            break;
        case 'North':
            spawnLocation.z -= 0.5;
            break;
        case 'South':
            spawnLocation.z += 0.5;
            break;
        case 'West':
            spawnLocation.x -= 0.5;
            break;
        case 'East':
            spawnLocation.x += 0.5;
            break;
    }
    if (playerGamemode === GameMode.creative && spawnEggs.includes(spawnEgg)) {
        e.cancel = true;
        const entityId = spawnEgg.replace('_spawn_egg', '');
        system.run(() => {
            const entity = overworld.spawnEntity(entityId, spawnLocation);
            entity.triggerEvent("sf_nba:randomize_variant");
        });
    }
});